/*
 Copyright by Boston University, 2016
 Authors: Josejulio Martínez, Daniel Kornhauser
 Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
 */
package com.aluxoft.earrecognition.intents;


import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;

import android.os.Environment;
import com.aluxoft.earrecognition.EarIdentifier;
import com.aluxoft.earrecognition.utils.ImageUtils;
import com.crashlytics.android.Crashlytics;
import com.yalantis.cameramodule.activity.BasePhotoActivity;
import com.yalantis.cameramodule.activity.CameraActivity;

import java.io.File;
import java.io.IOException;

import io.fabric.sdk.android.Fabric;

/**
 * Entry point for the search by feature.
 *
 * Takes the photo, sends to the SIFT activity and displays the Top match list.
 */
public class IntentSearchFeatures extends Activity{

    //private File location;

    public static final int KEY_REQUEST_IMAGE = 1;
    public static final int KEY_SIFT_ACTIVITY_LOADER = 2;
    public static final int KEY_TOP_X = 3;

    @Override
    protected void onCreate(Bundle saveInstanceState) {
        super.onCreate(saveInstanceState);
        Fabric.with(this, new Crashlytics());
        this.takePhoto();
    }


    public boolean takePhoto() {
        /*
        Intent i = new Intent(android.provider.MediaStore.ACTION_IMAGE_CAPTURE);
        try {
            location = ImageUtils.createTempImageFile();
        } catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }

        // if this gets modified, the onActivityResult in
        // FormEntyActivity will also need to be updated.
        i.putExtra(android.provider.MediaStore.EXTRA_OUTPUT, Uri.fromFile(location));
        try {
            startActivityForResult(i, KEY_REQUEST_IMAGE);
        } catch (ActivityNotFoundException e) {
            return false;
        }*/

        Intent intent = new Intent(this, CameraActivity.class);
        intent.putExtra(CameraActivity.PATH, Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES).getAbsolutePath());
        intent.putExtra(CameraActivity.OPEN_PHOTO_PREVIEW, true);
        intent.putExtra(CameraActivity.USE_FRONT_CAMERA, false);
        startActivityForResult(intent, KEY_REQUEST_IMAGE);
        return true;
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if(requestCode == KEY_REQUEST_IMAGE) {
            //Go grab the image and set it's location
            String filePath = data.getStringExtra(BasePhotoActivity.EXTRAS.PATH);
            if (filePath != null) {
                File location = new File(filePath);
                if (location != null && location.exists()) {
                    String path = location.getAbsolutePath();
                    Intent intent = new Intent("com.auriclon.activity_sift");
                    intent.putExtra("image_path", path);
                    startActivityForResult(intent, KEY_SIFT_ACTIVITY_LOADER);
                }
            }
        } else if (requestCode == KEY_SIFT_ACTIVITY_LOADER) {
            startActivityForResult(data, KEY_TOP_X);
        } else if (requestCode == KEY_TOP_X) {
            String case_id = data.getStringExtra("case_id");
            if (case_id == null) {
                case_id = "";
            }
            Intent returningIntent = new Intent(getIntent());
            returningIntent.putExtra(
                    "ear_search_result",
                    case_id);
            this.setResult(Activity.RESULT_OK, returningIntent);
            finish();
        }
    }
/*
    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (location != null) {
            outState.putString("location", location.toString());
        }
    }
*/
 }
