package com.aluxoft.earrecognition;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;

import java.util.concurrent.Callable;

import bolts.Continuation;
import bolts.Task;

/**
 * Created by josejuliomartinez on 02/10/15.
 */
public class IntentTransferingFeatures extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ProgressDialog loading = ProgressDialog.show(IntentTransferingFeatures.this,
                "Transfering", "Please wait while transfering the features...");
        loading.setCancelable(false);
        loading.setProgressStyle(ProgressDialog.STYLE_SPINNER);

        Task.callInBackground(new Callable<Object>() {
            @Override
            public Object call() throws Exception {
                synchronized (this) {
                    wait(1000);
                }
                return null;
            }
        }).continueWith(new Continuation<Object, Object>() {
            @Override
            public Object then(Task<Object> task) throws Exception {
                Intent returningIntent = new Intent(getIntent());
                returningIntent.putExtra("odk_intent_data", "The feature data should be here.");
                IntentTransferingFeatures.this.setResult(Activity.RESULT_OK, returningIntent);
                finish();
                return null;
            }
        }, Task.UI_THREAD_EXECUTOR);

    }
}
