/*
 Copyright by Boston University, 2016
 Authors: Josejulio Martínez, Daniel Kornhauser
 Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
 */
package com.aluxoft.earrecognition.common;

import java.util.ArrayList;

/**
 * Patient data.
 * Populated by PatientLoaderCommcare in PatientHashMap.
 */
public class Patient {

    private String caseId;
    private String name;
    private String gender;

    private ArrayList<EarFeature> features = new ArrayList<EarFeature>();

    public String getCaseId() {
        return caseId;
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }


    public void addFeature(EarFeature feature) {
        this.features.add(feature);
    }

    public ArrayList<EarFeature> getFeatures() {
        return this.features;
    }
}
