/*
 Copyright by Boston University, 2016
 Authors: Josejulio Martínez, Daniel Kornhauser
 Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
 */
package com.aluxoft.earrecognition.common;

import java.util.HashMap;

/**
 * Hashmap to store patients with their NameDistance.
 * Populated by PatientLoaderCommcare.
 */
public class PatientHashMap extends HashMap<String, NameDistance> {

    public void addPatient(Patient patient) {
        this.put(patient.getCaseId(), new NameDistance(0.0, patient));
    }

    public void computeDistance(EarFeature feature) {
        for (String caseId : this.keySet()) {
            NameDistance tuple = this.get(caseId);
            double minDistance = Double.MAX_VALUE;
            for (EarFeature feature2 : tuple.patient.getFeatures()) {
                minDistance = Math.min(feature.distance(feature2), minDistance);
            }
            tuple.distance = minDistance;
        }
    }

}

