/*
 Copyright by Boston University, 2016
 Authors: Josejulio Martínez, Daniel Kornhauser
 Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
 */
package com.aluxoft.earrecognition.activities;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;

import com.aluxoft.earrecognition.R;

import com.crashlytics.android.Crashlytics;
import com.yalantis.cameramodule.activity.BasePhotoActivity;
import com.yalantis.cameramodule.activity.CameraActivity;

import io.fabric.sdk.android.Fabric;

/**
 * Activity where we capture ear for recognition.
 * TODO: Add onscreen guide lines for ear acquisition
 */
public class EarCaptureActivity extends Activity {

    /*
     * (non-Javadoc)
     * @see android.app.Activity#onCreate(android.os.Bundle)
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Fabric.with(this, new Crashlytics());
        setContentView(R.layout.open_commcare_layout);

        Button button = (Button)this.findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openCamera();
            }
        });

    }

    public void openCamera() {
        Intent intent = new Intent(this, CameraActivity.class);
        intent.putExtra(CameraActivity.PATH, Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES).getAbsolutePath());
        intent.putExtra(CameraActivity.OPEN_PHOTO_PREVIEW, true);
        //intent.putExtra(CameraActivity.LAYOUT_ID, R.layout.fragment_camera_custom);
        intent.putExtra(CameraActivity.USE_FRONT_CAMERA, false);
        startActivityForResult(intent, 1000);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        System.out.println(resultCode);
        System.out.println(data);

        System.out.println(data.getExtras().get(BasePhotoActivity.EXTRAS.PATH));
        System.out.println(data.getExtras().get(BasePhotoActivity.EXTRAS.NAME));

        super.onActivityResult(requestCode, resultCode, data);
    }
}
