package com.aluxoft.earrecognition;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;

import java.io.File;
import java.util.concurrent.Callable;

import bolts.Continuation;
import bolts.Task;

/**
 * Created by josejuliomartinez on 07/10/15.
 */
public class SIFTActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_sift);

        ProgressDialog loading = ProgressDialog.show(SIFTActivity.this,
                "Searching matches", "Please wait while we search for matches...");
        loading.setCancelable(false);
        loading.setProgressStyle(ProgressDialog.STYLE_SPINNER);

        Task.callInBackground(new Callable<Object>() {
            @Override
            public Object call() throws Exception {
                synchronized (this) {
                    // Sift
                    EarIdentifier identifier = new EarIdentifier(null);
                    Intent intent = SIFTActivity.this.getIntent();
                    Bundle extras = intent.getExtras();
                    File imagePath = (File)extras.get("image_path");
                    String features = identifier.computeFeatures(imagePath.getAbsolutePath());
                    System.out.println(features);
                }
                return null;
            }
        }).continueWith(new Continuation<Object, Object>() {
            @Override
            public Object then(Task<Object> task) throws Exception {
                Intent intent = new Intent("com.auriclon.activity_select_user");
                startActivity(intent);
                return null;
            }
        }, Task.UI_THREAD_EXECUTOR);

    }
}
