package com.aluxoft.earrecognition.activities;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;

import com.aluxoft.earrecognition.EarIdentifier;
import com.aluxoft.earrecognition.R;
import com.aluxoft.earrecognition.utils.ImageUtils;

import java.io.File;
import java.io.IOException;

public class EarCaptureActivity extends Activity {
    
    Button getImage;
    Button returnToCommCare;

    File location;
    
    public static final int KEY_REQUEST_IMAGE = 1;
    
    /*
     * (non-Javadoc)
     * @see android.app.Activity#onCreate(android.os.Bundle)
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_callout);


        /*
        returnToCommCare = (Button)this.findViewById(R.id.button_commcare);
        returnToCommCare.setOnClickListener(new OnClickListener() {

            public void onClick(View v) {
                Intent i = new Intent("org.commcare.dalvik.action.CommCareSession");
                String sssd = "";
                sssd +=
                        "COMMAND_ID" + " " + "root" + " "
                                +
                                "CASE_ID" + " " + "case_id" + " " + "99de08b8-7235-41ba-9dbe-d1e5d70575cf" + " " +
                                "COMMAND_ID" + " " + "m1-f1";
                i.putExtra("ccodk_session_request", sssd);
                EarCaptureActivity.this.startActivity(i);
            }
        });

        // Load data from Commcare
        Cursor c = this.managedQuery(Uri.parse("content://org.commcare.dalvik.case/casedb/case"), null, null, null, null);
        for (int i=0;i<c.getColumnCount();++i) {
            System.out.print(c.getColumnName(i) + "|");
        }
        System.out.println();

        while (c.moveToNext()) {
            for (int i=0;i<c.getColumnCount();++i) {
                System.out.print(c.getString(i) + "|");
            }
            System.out.println();
        }

         */


        getImage = (Button)this.findViewById(R.id.extra_image_value);
        getImage.setOnClickListener(new OnClickListener() {
            public void onClick(View v) {
                Intent i = new Intent(android.provider.MediaStore.ACTION_IMAGE_CAPTURE);
                try {
                    location = ImageUtils.createTempImageFile();
                } catch (IOException e1) {
                    // TODO Auto-generated catch block
                    e1.printStackTrace();
                    return;
                }

                // if this gets modified, the onActivityResult in
                // FormEntyActivity will also need to be updated.
                i.putExtra(android.provider.MediaStore.EXTRA_OUTPUT, Uri.fromFile(location));
                try {
                    startActivityForResult(i, KEY_REQUEST_IMAGE);
                } catch (ActivityNotFoundException e) {
                    Toast.makeText(EarCaptureActivity.this, "No Camera", Toast.LENGTH_SHORT).show();
                }
            }

        });

        if(this.getLastNonConfigurationInstance() != null) {
            location = ((EarCaptureActivity)this.getLastNonConfigurationInstance()).location;
        }
        
        if(savedInstanceState != null) {
            location = new File(savedInstanceState.getString("location"));
        }
    }
    /* (non-Javadoc)
     * @see android.app.Activity#onActivityResult(int, int, android.content.Intent)
     */
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if(requestCode == KEY_REQUEST_IMAGE) {
            //Go grab the image and set it's location
            if(location == null || !location.exists()) {
                location = null;
            } else {
                String path = location.getAbsolutePath();
                EarIdentifier identifier = new EarIdentifier(null);
                Intent intent = new Intent("com.auriclon.activity_sift");
                intent.putExtra("image_path", path);
                startActivity(intent);
            }
        }
    }
    /* (non-Javadoc)
     * @see android.app.Activity#onResume()
     */
    @Override
    protected void onResume() {
        super.onResume();
    }
    /* (non-Javadoc)
     * @see android.app.Activity#onSaveInstanceState(android.os.Bundle)
     */
    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (location != null) {
            outState.putString("location", location.toString());
        }
    }
    /* (non-Javadoc)
     * @see android.app.Activity#onRetainNonConfigurationInstance()
     */
    @Override
    public Object onRetainNonConfigurationInstance() {
        return this;
    }

}
