package com.aluxoft.earrecognition.common;

import com.google.gson.Gson;

import org.opencv.core.Mat;

import java.util.ArrayList;

/**
 * Created by josejuliomartinez on 06/10/15.
 * Store the features of the ear.
 */
public class EarFeature {

    private Mat features;

    public Mat getFeatures() {
        return features;
    }

    public void setFeatures(Mat features) {
        this.features = features;
    }

    public EarFeature(Mat features) {
        this.setFeatures(features);
    }

    public String serializeFeatures() {
        Mat mFeatures = this.getFeatures();

        ArrayList<ArrayList<Integer>> features = new ArrayList<>();
        for (int i=0;i<mFeatures.rows();++i) {
            ArrayList<Integer> feature = new ArrayList<>();
            for (int j=0;j<mFeatures.cols();++j) {
                feature.add((int)mFeatures.get(i, j)[0]);
            }
            features.add(feature);
        }
        Gson gson = new Gson();
        return gson.toJson(features);
    }

}
