package com.aluxoft.earrecognition.activities;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;

import com.aluxoft.earrecognition.R;
import com.aluxoft.earrecognition.common.EarData;
import com.aluxoft.earrecognition.common.EarIdList;
import com.aluxoft.earrecognition.common.NameDistance;
import com.google.gson.Gson;

/**
 * Shows top 10 matches, allows to register if not match is satisfactory.
 * TODO: Populate list
 */
public class SelectUserActivity extends Activity {

    public static String currentSerializedEar;

    public EarIdList earIdList = null;

    //private EarIdList earIdList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_select_user);

        String list = this.getIntent().getStringExtra("list");
        this.earIdList = new Gson().fromJson(list, EarIdList.class);
        SelectUserActivity.currentSerializedEar = this.earIdList.getCurrentFeature().serializeFeatures();

        Button registerButton = (Button) findViewById(R.id.register_commcare);

        ArrayAdapter<NameDistance> arrayAdapter = new ArrayAdapter<NameDistance>(
                this,
                android.R.layout.simple_list_item_1,
                this.earIdList.getTop()
        );

        ListView topNListView = (ListView)findViewById(R.id.topNListView);
        topNListView.setAdapter(arrayAdapter);

        registerButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent i = new Intent("org.commcare.dalvik.action.CommCareSession");
                String sssd = "COMMAND_ID" + " " + "root" + " " + "COMMAND_ID" + " " + "m0-f0";
                i.putExtra("ccodk_session_request", sssd);
                SelectUserActivity.this.startActivity(i);
            }
        });


    }
}
