package com.aluxoft.earrecognition;

import com.aluxoft.earrecognition.common.EarData;
import com.aluxoft.earrecognition.common.EarFeature;
import com.aluxoft.earrecognition.common.EarIdList;
import com.aluxoft.earrecognition.utils.OpenCvUtils;

import org.opencv.core.Mat;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.features2d.DescriptorExtractor;
import org.opencv.features2d.FeatureDetector;
import org.opencv.highgui.Highgui;

/**
 * Computes and Identifies ear features
 */
public class EarIdentifier {

    private EarData database;

    public EarIdentifier(EarData _database) {
        this.database = _database;
    }

    public void setDatabase(EarData _database) {
        this.database = _database;
    }

    /**
     * Do the ear identification process.
     * @param feature The result of the identification.
     * @return
     */
    public EarIdList identify(EarFeature feature) {
        return null;
    }


    public EarFeature computeFeatures(String imagePath) {

        Mat image, descriptors;
        MatOfKeyPoint keypoints;

        descriptors = new Mat();
        keypoints = new MatOfKeyPoint();

        image = Highgui.imread(imagePath, Highgui.CV_LOAD_IMAGE_GRAYSCALE);

        OpenCvUtils.resizeMat(image, 160, 120);

        FeatureDetector detector = FeatureDetector.create(FeatureDetector.SIFT);
        detector.detect(image, keypoints);
        DescriptorExtractor extractor = DescriptorExtractor.create(DescriptorExtractor.SIFT);
        extractor.compute(image, keypoints, descriptors);
        return new EarFeature(descriptors);
    }


    static {
        System.loadLibrary("opencv_java");
        System.loadLibrary("nonfree");
    }

}
