package com.aluxoft.earrecognition.common;

import com.aluxoft.earrecognition.activities.SIFTActivity;
import com.aluxoft.earrecognition.utils.OpenCvUtils;
import com.google.gson.Gson;

import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Core;
import org.opencv.core.MatOfDMatch;
import org.opencv.features2d.DMatch;
import org.opencv.features2d.DescriptorMatcher;

import java.util.ArrayList;

/**
 * Represents Ear Features
 *
 */
public class EarFeature {

    private static DescriptorMatcher matcher;

    private Mat features;

    static {
        System.loadLibrary("opencv_java");
        System.loadLibrary("nonfree");
        matcher = DescriptorMatcher.create(DescriptorMatcher.BRUTEFORCE);
    }

    public Mat getFeatures() {
        return features;
    }

    public void setFeatures(Mat features) {
        this.features = features;
    }

    public EarFeature(Mat features) {
        this.setFeatures(features);
    }

    public String serializeFeatures() {
        Mat mFeatures = this.getFeatures();

        ArrayList<ArrayList<Integer>> features = new ArrayList<>();
        for (int i=0;i<mFeatures.rows();++i) {
            ArrayList<Integer> feature = new ArrayList<>();
            for (int j=0;j<mFeatures.cols();++j) {
                feature.add((int)mFeatures.get(i, j)[0]);
            }
            features.add(feature);
        }
        Gson gson = new Gson();
        return gson.toJson(features);
    }

    public double distance(EarFeature feature2) {
        MatOfDMatch matches = new MatOfDMatch();
        matcher.match(this.getFeatures(), feature2.getFeatures(), matches);
        DMatch[] aMatches = matches.toArray();

        double distance = 0;
        for (int i=0;i<aMatches.length;++i) {
            distance += aMatches[i].distance;
        }

        return distance;
    }

    public static EarFeature unserialize(String featuresString) {
        final int kFeatureSize = 128;
        Gson gson = new Gson();
        ArrayList< ArrayList<Double> > features = new ArrayList<>();
        features = gson.fromJson(featuresString, features.getClass());

        Mat mFeatures = new Mat();
        mFeatures.create(features.size(), kFeatureSize, CvType.CV_32S);

        int buffer[] = new int[1];
        for (int i=0;i<features.size();++i) {
            ArrayList<Double> feature = features.get(i);
            for (int j=0;j<feature.size();++j) {
                buffer[0] = feature.get(j).intValue();
                mFeatures.put(i, j, buffer);
            }
        }

        EarFeature earFeature = new EarFeature(mFeatures);
        return earFeature;
    }

}
