package com.aluxoft.earrecognition.common;

import java.util.HashMap;

/**
 * Created by josejuliomartinez on 06/10/15.
 * The database of all the ears.
 */
public class EarData {

    private HashMap<String, NameDistance> persons = new HashMap<String, NameDistance>();


    public void addPerson(Person person) {
        this.persons.put(person.getCaseId(), new NameDistance(0.0, person));

    }

    public HashMap<String, NameDistance> getPersons() {
        return this.persons;
    }

    public void computeDistance(EarFeature feature) {
        for (String caseId : this.persons.keySet()) {
            NameDistance tuple = this.persons.get(caseId);
            double minDistance = Double.MAX_VALUE;
            for (EarFeature feature2 : tuple.person.getFeatures()) {
                minDistance = Math.min(feature.distance(feature2), minDistance);
            }
            tuple.distance = minDistance;
        }
    }

}

