/*
 Copyright by Boston University, 2016
 Authors: Josejulio Martínez, Daniel Kornhauser
 Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php
 */
package com.aluxoft.earrecognition.utils;

import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class OpenCvUtils {

    public static void resizeMat(Mat image, double maxWidth, double maxHeight) {
        if (image.width() <= maxWidth && image.height() <= maxHeight) {
            return;
        }

        double ratio = (double)image.width() / (double)image.height();
        double width, height;
        if (ratio > 1) {
            width = maxWidth;
            height = maxWidth * ((double)image.height()/(double)image.width());
        } else {
            height = maxHeight;
            width = maxHeight* ratio;
        }
        Imgproc.resize(image, image, new Size(width, height));
    }


    private OpenCvUtils() {

    }

}
